/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.List;
import unichef.integracao.goomer.AtualizadorContaGoomer;
import unichef.pojo.ContaCliente;
import unichef.pojo.ControleContaIntegracao;
import unichef.regranegocio.ContaClienteRN;
import unichef.regranegocio.ControleContaIntegracaoRN;

public class ContaIntegracaoScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();

    public ContaIntegracaoScheduler() {
        super(Cron.every15seconds(), TipoJob.CONTA_INTEGRACAO_YODA);
    }

    public boolean isAtivo() {
        return AtualizadorContaGoomer.isHabilitado((Filial)this.sessao.getFilial());
    }

    public void execute() throws UnicoMensagemUsuarioException {
        List controles = ControleContaIntegracaoRN.getInstance().buscarListaParaProcessar();
        for (ControleContaIntegracao controle : controles) {
            ContaCliente conta = ContaClienteRN.getInstance().buscarPorHashCompleta(controle.getHashConta());
            AtualizadorContaGoomer.atualizarConta((ContaCliente)conta, (Sessao)this.sessao);
            ControleContaIntegracaoRN.getInstance().excluir((AbstractPojo)controle, this.sessao);
        }
    }
}

