/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.scanntechcanaisvenda.SincronizadorScanntechCanaisVenda;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.scanntechcanaisvenda.ConfiguracaoScanntechCanaisVenda;
import br.intelidata.commons.domain.regranegocio.scanntech.ConfiguracaoScanntechCanaisVendaRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;

public class ScanntechCanaisVendaScheduler
extends RecurringYodaJob {
    private final ConfiguracaoScanntechCanaisVenda configuracao = ConfiguracaoScanntechCanaisVendaRN.getInstance().buscar();

    public ScanntechCanaisVendaScheduler() {
        super(Cron.hourly((int)2), TipoJob.SCANNTECH_CANAIS_VENDA_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        new SincronizadorScanntechCanaisVenda(this.configuracao).sincronizar(Contexto.getInstance().getSessao());
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SCANNTECH) && this.configuracao != null && this.configuracao.isSincronizacaoAutomatica();
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

