/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Agendamento;
import br.intelidata.commons.domain.pojo.enuns.TarefaAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.ferramentas.agendamento.regranegocio.AgendamentoRN;
import br.intelidata.commons.modulo.integracao.integracaoaccera.regranegocio.IntegracaoAcceraRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class IntegracaoAcceraScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();
    private Agendamento agendamento;

    public IntegracaoAcceraScheduler() {
        super(Cron.daily((int)3), TipoJob.INTEGRACAO_ACCERA_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
        this.agendamento = AgendamentoRN.getInstance().buscaAgendamento(TarefaAgendamento.ACCERA.getId());
    }

    public void execute() throws UnicoMensagemUsuarioException {
        String diretorio = PropriedadeRN.getInstance().getPropriedadeString(this.sessao.getFilial(), 677);
        if (Util.stringNullOrEmpty((String)diretorio)) {
            throw new UnicoMensagemUsuarioException("INT60", "N\u00e3o foi configurado o diret\u00f3rio para exporta\u00e7\u00e3o dos arquivos da integra\u00e7\u00e3o ACCERA. Exporta\u00e7\u00e3o abortada");
        }
        if (!Files.exists(Paths.get(diretorio, new String[0]), new LinkOption[0])) {
            throw new UnicoMensagemUsuarioException("INT61", "O diret\u00f3rio " + diretorio + " configurado para exporta\u00e7\u00e3o dos arquivos da integra\u00e7\u00e3o ACCERA n\u00e3o existe. Exporta\u00e7\u00e3o abortada");
        }
        IntegracaoAcceraRN.getInstance().gerarIntegracaoJob(this.sessao, diretorio, this.sessao.getFilial(), DataHoraFactory.getData().minusDays(30L), DataHoraFactory.getData());
    }

    public boolean isAtivo() {
        return this.agendamento != null && !Util.stringNullOrEmpty((String)this.agendamento.getHoras());
    }

    public String getCronExpression() {
        return AgendamentoRN.getInstance().getExpressaoCron(this.agendamento, "0");
    }
}

