/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.sistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.FilaSMS;
import br.intelidata.commons.domain.pojo.LoteSMS;
import br.intelidata.commons.domain.pojo.enuns.StatusAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.FilaSMSCommonRN;
import br.intelidata.commons.domain.regranegocio.LoteSMSCommonRN;
import br.intelidata.commons.modulo.c3po.sms.provedor.IProvedorSMS;
import br.intelidata.commons.modulo.c3po.sms.provedor.ProvedorSMSFactory;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.ArrayList;
import java.util.List;

public class SmsFilaScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();
    private IProvedorSMS provedorSMS = ProvedorSMSFactory.novoProvedor();

    public SmsFilaScheduler() {
        super(Cron.dailyMinute((int)1), TipoJob.SMS_FILA_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        for (FilaSMS fila : FilaSMSCommonRN.getInstance().buscarLista()) {
            List listLoteSMS = LoteSMSCommonRN.getInstance().buscaListaPorIdFila(fila.getId());
            List numeros = this.getNumeros(listLoteSMS);
            if (this.provedorSMS.enviar(fila.getMensagem(), numeros)) {
                LoteSMSCommonRN.getInstance().excluiLista(this.sessao, listLoteSMS);
                FilaSMSCommonRN.getInstance().excluir((AbstractPojo)fila, this.sessao);
                continue;
            }
            fila.setStatus(StatusAgendamento.FALHOU);
            FilaSMSCommonRN.getInstance().alterar((AbstractPojo)fila, this.sessao);
        }
    }

    private List<String> getNumeros(List<LoteSMS> loteSMS) {
        ArrayList<String> result = new ArrayList<String>();
        for (LoteSMS loteSM : loteSMS) {
            result.add(loteSM.getNumeroCelular());
        }
        return result;
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SMS);
    }
}

