/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.nfse;

import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.PojoRemoto;
import br.intelidata.commons.core.documentosfiscais.unfse.TransmissorNfse;
import br.intelidata.commons.core.documentosfiscais.unfse.TransmissorNfseLocal;
import br.intelidata.commons.core.documentosfiscais.unfse.impressao.RetornoImpressaoRpsNfse;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.CancelarRpsRequest;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.ConsultarRpsRequest;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.EnviarRpsRequest;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.ImpressaoNfseRequest;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.InutilizarNumeracaoNfseRequest;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.ProcessarRetornoLoteNfseRequest;
import br.intelidata.commons.core.documentosfiscais.unfse.pojo.ProcessarRetornoLoteNfseReturn;
import br.intelidata.commons.core.documentosfiscais.unfse.provedor.RetornoProvedor;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nfse/"})
public class NfseController {
    @RequestMapping(value={"enviarRps"})
    @DBAutoCommit
    public RetornoProvedor enviarRps(@RequestBody EnviarRpsRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        return transmissor.enviarRps(request.getParametrosNfse(), request.getPrestador(), request.getRps());
    }

    @RequestMapping(value={"enviarListaRps"})
    @DBAutoCommit
    public RetornoProvedor enviarListaRps(@RequestBody EnviarRpsRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        return transmissor.enviarRps(request.getParametrosNfse(), request.getPrestador(), request.getListaRps());
    }

    @RequestMapping(value={"cancelarRps"})
    @DBAutoCommit
    public RetornoProvedor cancelarRps(@RequestBody CancelarRpsRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        return transmissor.cancelarRps(request.getPrestador(), request.getRps(), request.getMotivo());
    }

    @RequestMapping(value={"consultarRps"})
    @DBAutoCommit
    public RetornoProvedor consultarRps(@RequestBody ConsultarRpsRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        return transmissor.consultarRps(request.getPrestador(), request.getSerie(), request.getModelo(), request.getNumeroNfse(), request.getNumeroRps(), request.getChaveAcesso(), request.getIdNotaFiscal(), request.getProtocolo(), request.getCodigoVerificacao(), request.getDataEmissao());
    }

    @RequestMapping(value={"inutilizarNumeracao"})
    @DBAutoCommit
    public RetornoProvedor inutilizarNumeracao(@RequestBody InutilizarNumeracaoNfseRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        return transmissor.inutilizarNumeracao(request.getPrestador(), request.getNumeroInicial(), request.getNumeroFinal(), request.getSerie());
    }

    @RequestMapping(value={"processarRetornoLote"})
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="O melhor seria ajustar o charset, n\u00e3o o fiz pois n\u00e3o sei qual o correto")
    @DBAutoCommit
    public ProcessarRetornoLoteNfseReturn processarRetornoLote(@RequestBody ProcessarRetornoLoteNfseRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        List lista = transmissor.processarRetornoLote(new String(request.getArquivoXml()));
        ProcessarRetornoLoteNfseReturn retorno = new ProcessarRetornoLoteNfseReturn();
        retorno.setListaRetornoProvedor(lista);
        return retorno;
    }

    @RequestMapping(value={"impressao"})
    @DBAutoCommit
    public RetornoImpressaoRpsNfse impressao(@RequestBody ImpressaoNfseRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfse transmissor = this.getTransmissor((PojoRemoto)request);
        return transmissor.imprimirNFSe(request.getPrestador(), request.getRps());
    }

    private TransmissorNfse getTransmissor(PojoRemoto request) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(Long.valueOf(request.getIdFilial()));
        TransmissorNfseLocal transmissorNfse = new TransmissorNfseLocal(filial);
        transmissorNfse.setListenerProcesso((mensagem, pularLinha) -> {});
        return transmissorNfse;
    }
}

