/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.yoda;

import br.intelidata.commons.core.documentosfiscais.common.enums.TipoCertificado;
import br.intelidata.commons.core.documentosfiscais.common.pojo.DadosCertificado;
import br.intelidata.commons.core.documentosfiscais.sefaz.common.AssinaturaDigital;
import br.intelidata.commons.core.documentosfiscais.util.DadosCertificadoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Certificado;
import br.intelidata.commons.modulo.cadastros.regranegocio.CertificadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class CertificadoController {
    private static Logger LOGGER = LoggerFactory.getLogger(CertificadoController.class);

    @DBAutoCommit
    public void inicializarCertificadoA3RepositorioWindows() {
        List certificados = CertificadoRN.getInstance().buscarLista();
        for (Certificado certificado : certificados) {
            if (certificado.getTipo() != TipoCertificado.MSCAPI) continue;
            String senha = "";
            if (!Util.stringNullOrEmpty((String)certificado.getSenha())) {
                senha = UnicoCrypt.decript((String)certificado.getSenha());
            }
            try {
                DadosCertificado dadosCertificado = DadosCertificadoUtil.carregarCertificado((TipoCertificado)certificado.getTipoCertificado(), (byte[])certificado.getBinario(), (String)certificado.getDiretorioDLL(), (String)senha, (String)certificado.getAlias());
                AssinaturaDigital assinaturaDigital = new AssinaturaDigital(dadosCertificado);
                assinaturaDigital.setElementosAssinaveis(new String[]{"infNFe"});
                assinaturaDigital.assinarDocumento("<?xml version='1.0' encoding='UTF-8'?><NFe xmlns=\"http://www.portalfiscal.inf.br/nfe\"><infNFe Id=\"NFe51140809426452000104650010000000881154476997\" versao=\"4.00\"><ide><cUF>51</cUF></ide></infNFe></NFe>");
            }
            catch (UnicoMensagemUsuarioException e) {
                LOGGER.error("YODA", (Throwable)e);
            }
        }
    }
}

