/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.yoda.context;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.UnicoProperties;
import br.intelidata.commons.core.sql.ParametroConexao;
import br.intelidata.commons.core.sql.SGBD;
import br.intelidata.commons.core.sql.SenhaBanco;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.domain.pojo.Configuracao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoCommonRN;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.yoda.app.yoda.util.SwingUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties
public class YodaProperties {
    private static Logger logger = LoggerFactory.getLogger(YodaProperties.class);
    private ParametroConexao parametroConexao;
    private Sessao sessao;
    private Filial filial;
    private UnicoProperties unicoProperties;
    private String dataBaseName;

    public YodaProperties(@Autowired DataSource datasource) {
        datasource.setPassword(new SenhaBanco().getPwd());
        this.extrairNomeBase(datasource);
        this.acrescentarAppName(datasource);
    }

    private void extrairNomeBase(DataSource datasource) {
        String url = datasource.getUrl();
        int idx = url.lastIndexOf("/");
        this.dataBaseName = url.substring(idx + 1, url.length());
    }

    private void acrescentarAppName(DataSource datasource) {
        String url = datasource.getUrl() + "?ApplicationName=YODA";
        datasource.setUrl(url);
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    public ParametroConexao getParametroConexao() {
        if (this.parametroConexao == null) {
            this.parametroConexao = new ParametroConexao();
            this.parametroConexao.setBaseDados(this.getDataBaseName());
            this.parametroConexao.setSgdb(SGBD.POSTGRES);
        }
        return this.parametroConexao;
    }

    public Sessao getSessao() {
        if (this.sessao == null) {
            this.sessao = Sessao.createSessao((Long)UsuarioRN.ID_USUARIO_DEFAULT, null);
        }
        return this.sessao;
    }

    @DBAutoCommit
    public Filial getFilial() {
        if (this.filial == null) {
            this.filial = FilialRN.getInstance().buscaMatriz();
            if (this.filial == null) {
                try {
                    this.filial = FilialRN.getInstance().buscarFilial();
                }
                catch (UnicoMensagemUsuarioException e) {
                    logger.error("Erro ao buscar filial", (Throwable)e);
                }
            }
        }
        return this.filial;
    }

    @DBAutoCommit
    public Map<Integer, Object> getPropriedades(Sessao sessao) {
        LicencaManager.getInstance().carregarLicencas();
        List preferencias = ConfiguracaoCommonRN.getInstance().buscarListaPorIdFilial(sessao.getIdFilial());
        preferencias.forEach(preferencia -> {
            boolean isCRMSenhaServerSMTP;
            boolean isSenhaUsuarioBanco = preferencia.getChave() == 213;
            boolean isSenhaServerSMTP = preferencia.getChave() == 40;
            boolean bl = isCRMSenhaServerSMTP = preferencia.getChave() == 198;
            if (isSenhaUsuarioBanco || isSenhaServerSMTP || isCRMSenhaServerSMTP) {
                String senha = preferencia.getValor();
                if (isSenhaUsuarioBanco && !senha.equalsIgnoreCase("postgres")) {
                    senha = UnicoCrypt.decript((String)senha);
                } else if ((isSenhaServerSMTP || isCRMSenhaServerSMTP) && UnicoCrypt.decriptIfErroReturnNull((String)senha) != null) {
                    senha = UnicoCrypt.decript((String)senha);
                }
                preferencia.setValor(senha);
            }
        });
        try {
            PropriedadeRN.getInstance().carregaValores(sessao);
        }
        catch (UnicoMensagemUsuarioException e) {
            logger.error("Erro ao buscar propriedades", (Throwable)e);
        }
        return preferencias.stream().collect(Collectors.toMap(Configuracao::getChave, Configuracao::getValor));
    }

    @Bean
    public UnicoProperties getUnicoProperties() {
        if (this.unicoProperties == null) {
            this.unicoProperties = new UnicoProperties();
            this.unicoProperties.recarregaProperties();
        }
        return this.unicoProperties;
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    @DBAutoCommit
    public void verificaPropriedadeServidorYoda() {
        if (ControleRN.getInstance().isServidorPdvSecundario()) {
            return;
        }
        List filiais = FilialRN.getInstance().buscarLista();
        for (Filial filial : filiais) {
            boolean utilizarYoda = PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 712);
            if (utilizarYoda) continue;
            SwingUtil.showMensagemInformacaoComTempo((String)"YODA9", (String)"Yoda n\u00e3o pode ser iniciado.\nServidor Yoda n\u00e3o est\u00e1 ativo.\nVerifique a propriedade 'Servidor  Yoda - Habilitar o servidor Yoda'.", (int)5, (boolean)false);
            System.exit(0);
        }
    }

    @Bean
    public IDialect conditionalCommentDialect() {
        return new Java8TimeDialect();
    }
}

