/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.yoda.controller;

import br.intelidata.api.pdv.PdvController;
import br.intelidata.api.pdv.nfce.NfceController;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusCargaBasePdv;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusConexaoPdv;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusReplicadorPdv;
import br.intelidata.commons.domain.pojo.pafecf.StatusPdvEx;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import unipaf.pojo.nfce.RetornoStatusServico;
import unipaf.servidor.nfce.StatusPdvFilial;

@Controller
public class StatusPdvController {
    private static final String HEX_RED = "#F5929B";
    private static final String HEX_YELLOW = "#FFFF00";
    private static final String HEX_GREEN = "#80C58C";
    private final Logger log = LoggerFactory.getLogger(StatusPdvController.class);
    private PdvController pdvController;
    private NfceController nfceController;
    private List<StatusPdvFilial> listStatusNfce = new ArrayList();
    private List<StatusPdvEx> listStatusPdv = new ArrayList();

    @Autowired
    public StatusPdvController(PdvController pdvController, NfceController nfceController) {
        this.pdvController = pdvController;
        this.nfceController = nfceController;
    }

    @GetMapping(value={"/"})
    public ModelAndView statusPdv() {
        this.listStatusPdv = this.pdvController.getListaStatus();
        try {
            this.listStatusNfce = this.nfceController.getListaStatus();
        }
        catch (UnicoMensagemUsuarioException e) {
            this.log.error("Falha ao buscar lista de status dos PDVs", (Throwable)e);
        }
        boolean nfceHabilitada = this.ajustaCoresStatusNfce();
        this.ajustaCoresStatusPdv();
        ModelAndView model = new ModelAndView();
        model.setViewName("status-pdv");
        model.addObject("integracaoNfce", (Object)nfceHabilitada);
        model.addObject("statusNfce", (Object)this.listStatusNfce);
        model.addObject("statusPdv", (Object)this.listStatusPdv);
        model.addObject("versaoUniplus", (Object)UnicoSistema.getVersao());
        return model;
    }

    @GetMapping(value={"/consultar-status-nfce"})
    public ModelAndView testarStatusNfce(@RequestParam(required=true) String filial) {
        String statusRetorno = "Status desconhecido";
        try {
            StatusPdvFilial status = new StatusPdvFilial();
            status.setFilial(filial);
            RetornoStatusServico retorno = this.nfceController.consultarStatus(status);
            statusRetorno = retorno.getEx() != null ? retorno.getEx().getMessage() : "Status: " + retorno.getStatus() + "\nMotivo: " + retorno.getMotivo();
        }
        catch (UnicoMensagemUsuarioException e) {
            this.log.error("Erro ao consultar status NFC-e", (Throwable)e);
        }
        String mensagem = "NFC-e filial " + filial + "\n" + statusRetorno;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("consultar-status-nfce");
        modelAndView.addObject("mensagem", (Object)mensagem);
        return modelAndView;
    }

    private void ajustaCoresStatusPdv() {
        for (StatusPdvEx status : this.listStatusPdv) {
            this.setCor(() -> status.getStatusConexao() == StatusConexaoPdv.ONLINE, StatusPdvEx::setHexBgStatusConexao, (Object)status, HEX_GREEN, HEX_RED);
            this.setCor(() -> status.getStatusCargaBase() == StatusCargaBasePdv.OK, StatusPdvEx::setHexBgStatusCargaBase, (Object)status, HEX_GREEN, HEX_RED);
            this.setCor(() -> status.getStatusReplicador() == StatusReplicadorPdv.OK, StatusPdvEx::setHexBgStatusReplicador, (Object)status, HEX_GREEN, HEX_RED);
        }
    }

    private boolean ajustaCoresStatusNfce() {
        LocalDate hoje = DataHoraFactory.getData();
        int qtdConfigurado = 0;
        for (StatusPdvFilial status : this.listStatusNfce) {
            if (!status.isIntegracaoNfce() || status.getValidadeCertificado() == null) continue;
            ++qtdConfigurado;
            LocalDate validade = status.getValidadeCertificado();
            if (validade.compareTo(hoje) <= 0) {
                status.setHexBgValidadeCertificado(HEX_RED);
            } else if (ChronoUnit.DAYS.between(hoje, validade) <= 30L) {
                status.setHexBgValidadeCertificado(HEX_YELLOW);
            } else {
                status.setHexBgValidadeCertificado(HEX_GREEN);
            }
            this.setCor(() -> Util.intNullOuZero((Integer)status.getPendenciaContigencias()), StatusPdvFilial::setHexBgPendenciaContigencias, (Object)status, HEX_GREEN, HEX_RED);
            this.setCor(() -> Util.intNullOuZero((Integer)status.getPendenciaInutilizacoes()), StatusPdvFilial::setHexBgPendenciaInutilizacoes, (Object)status, HEX_GREEN, HEX_RED);
            this.setCor(() -> Util.intNullOuZero((Integer)status.getPendenciasProcessamentos()), StatusPdvFilial::setHexBgPendenciaProcessamentos, (Object)status, HEX_GREEN, HEX_RED);
        }
        return qtdConfigurado > 0;
    }

    private <T> void setCor(BooleanSupplier condicao, BiConsumer<T, String> metodoSet, T obj, String corTrue, String corFalse) {
        if (condicao.getAsBoolean()) {
            metodoSet.accept(obj, corTrue);
        } else {
            metodoSet.accept(obj, corFalse);
        }
    }
}

