SELECT *
FROM (
       SELECT
         p.procod,
         p.prodes,
         p.prodesrdz,
         p.prounid,
         p.trbid,
         p.proprccst,
         p.proprc1,
         p.procest,
         p.proprccstmed,
         p.proncm,
         p.proipi,
         imp_cof.impfedst     cst_pis_cofins_entrada,
         imp_cof.impfedstsai  cst_pis_cofins_saida,
         imp_cof.impfedalq    percentual_cofins_entrada,
         imp_cof.impfedalqsai percentual_cofins_saida,
         imp_pis.impfedalq    percentual_pis_entrada,
         imp_pis.impfedalqsai percentual_pis_saida
       FROM produto p
         LEFT JOIN impostos_federais_produto imp_prod_cof ON p.procod = imp_prod_cof.procod
         LEFT JOIN impostos_federais imp_cof ON imp_cof.impfedsim = imp_prod_cof.impfedsim AND imp_cof.impfedtip = 'C'
         LEFT JOIN impostos_federais_produto imp_prod_pis ON p.procod = imp_prod_pis.procod
         LEFT JOIN impostos_federais imp_pis ON imp_pis.impfedsim = imp_prod_pis.impfedsim AND imp_pis.impfedtip = 'P'
     ) AS produto
WHERE percentual_cofins_entrada IS NOT NULL 
      AND percentual_pis_entrada IS NOT NULL 
ORDER BY cast(procod AS BIGINT)