/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda;

import br.intelidata.commons.core.IconesFactory;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.ContextoListener;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.ConectaBanco;
import br.intelidata.commons.core.sql.ConnectionSql;
import br.intelidata.commons.core.sql.NovoParametroConexao;
import br.intelidata.commons.core.sql.ParametroConexao;
import br.intelidata.commons.core.sql.SGBD;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.atualizador.AtualizacaoBaseYoda;
import br.intelidata.yoda.app.yoda.CertificadoController;
import br.intelidata.yoda.app.yoda.context.ContextoYoda;
import br.intelidata.yoda.app.yoda.context.YodaProperties;
import br.intelidata.yoda.app.yoda.util.SwingUtil;
import br.intelidata.yoda.core.spring.config.LocalDateConverter;
import br.intelidata.yoda.core.spring.config.LocalDateTimeConverter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ClassPathResource;
import org.springframework.format.FormatterRegistry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import unicoweb.ConfiguraYoda;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableAsync
@EnableScheduling
@ComponentScan(value={"br.intelidata"})
@SpringBootApplication(exclude={SecurityAutoConfiguration.class, FreeMarkerAutoConfiguration.class})
public class YodaApplication
extends WebMvcConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(YodaApplication.class);
    private static ConfigurableApplicationContext context;
    private YodaProperties yodaProperties;
    private IConnectionHandler connectionHandler;

    @Autowired
    public YodaApplication(YodaProperties yodaProperties, AtualizacaoBaseYoda atualizacaoBaseYoda, IConnectionHandler connectionHandler) {
        this.yodaProperties = yodaProperties;
        this.connectionHandler = connectionHandler;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable ex) {
            LOG.error("Log ao atribuir look and feel", ex);
        }
        this.iniciarConnectionYoda(yodaProperties.getParametroConexao());
        this.preIniciarContextoYoda();
        atualizacaoBaseYoda.verificarAtualizacaoBase();
        Sessao sessao = yodaProperties.getSessao();
        Filial filial = yodaProperties.getFilial();
        if (filial != null) {
            LOG.info("Filial do Yoda: " + filial.getCodigo() + " - " + filial.getNome());
            sessao.setIdFilial(filial.getId());
        }
        this.iniciarContextoYoda(sessao, filial);
        yodaProperties.verificaPropriedadeServidorYoda();
        this.adicionarSystray();
    }

    public static void main(String[] args) {
        ConfiguraYoda.setup((SGBD)SGBD.POSTGRES);
        ParametroConexao param = new NovoParametroConexao().getUniplusTask("YODA");
        ConectaBanco conectaBanco = new ConectaBanco(param);
        LOG.info("URL: {}", (Object)conectaBanco.getUrl());
        try (Connection cnn = conectaBanco.conectar();){
            LOG.info("Conex\u00e3o com o banco OK");
        }
        catch (UnicoMensagemUsuarioException | SQLException e) {
            LOG.error("", e);
            return;
        }
        BasicConfigurator.configure();
        try {
            LOG.info("YODA Starting");
            context = new SpringApplicationBuilder(new Class[]{YodaApplication.class}).headless(false).run(args);
            YodaApplication.inicializarCertificadoA3RepositorioWindows((ConfigurableApplicationContext)context);
        }
        catch (Throwable e) {
            LOG.error("#YODA", e);
        }
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new LocalDateConverter("yyyy-MM-dd"));
        registry.addConverter((Converter)new LocalDateTimeConverter("yyyy-MM-dd'T'HH:mm:ss.SSSz"));
    }

    private void preIniciarContextoYoda() {
        Contexto.getInstance().setContextoListener((ContextoListener)new ContextoYoda());
    }

    private void iniciarContextoYoda(Sessao sessao, Filial filial) {
        Contexto.getInstance().setSessao(sessao);
        Contexto.getInstance().setFilial(filial);
        Contexto.getInstance().setMapPropriedades(this.yodaProperties.getPropriedades(sessao));
    }

    private void iniciarConnectionYoda(ParametroConexao parametroConexao) {
        ConnectionSql.setConfiguraConexao((ParametroConexao)parametroConexao);
    }

    private void adicionarSystray() {
        if (!SystemTray.isSupported()) {
            LOG.error("System tray n\u00e3o \u00e9 suportado!");
            return;
        }
        SystemTray systemTray = SystemTray.getSystemTray();
        Image image = IconesFactory.getImageIcon((String)IconesFactory.Aplicacao.ICONE_APLICACAO).getImage();
        PopupMenu trayPopupMenu = new PopupMenu();
        MenuItem menuAtualizador = new MenuItem("Gerenciador de vers\u00f5es");
        menuAtualizador.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        trayPopupMenu.add(menuAtualizador);
        if (LicencaManager.getInstance().isUniMobileComanda() || LicencaManager.getInstance().isUniMobilePDV() || LicencaManager.getInstance().isUniMobileVendas() || LicencaManager.getInstance().isUniMobilePOSIntegrado()) {
            MenuItem menuSessoesMobile = new MenuItem("Sess\u00f5es Unimobile");
            menuSessoesMobile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            trayPopupMenu.add(menuSessoesMobile);
        }
        MenuItem action = new MenuItem("Reiniciar");
        action.addActionListener(e -> this.acaoSystray(true));
        trayPopupMenu.add(action);
        MenuItem menuParar = new MenuItem("Parar");
        menuParar.addActionListener(e -> this.acaoSystray(false));
        trayPopupMenu.add(menuParar);
        TrayIcon trayIcon = new TrayIcon(image, "Servidor YODA", trayPopupMenu);
        trayIcon.setImageAutoSize(true);
        try {
            systemTray.add(trayIcon);
        }
        catch (Throwable ex) {
            LOG.error("Erro ao adicionar menu no system tray!", ex);
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Sa\u00edda do sistema para reiniciar")
    private void acaoSystray(boolean reiniciar) {
        try {
            if (!SwingUtil.isSenhaTecnicaOK()) {
                return;
            }
            if (reiniciar) {
                String userDir = System.getProperty("user.dir");
                File targetFile = new File(userDir + "\\restart.jar");
                boolean restartJarExiste = targetFile.exists();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (!restartJarExiste) {
                            ClassPathResource classPathResource = new ClassPathResource("restart.jar");
                            InputStream jarRestart = classPathResource.getInputStream();
                            Files.copy(jarRestart, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            IOUtils.closeQuietly((InputStream)jarRestart);
                        }
                        String comando = "\"" + userDir + "\\jre\\bin\\javaw.exe\" -jar \"" + userDir + "\\restart.jar\" \"" + userDir + "\\Yoda.exe\" 5000";
                        Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", comando});
                    }
                    catch (Throwable ex) {
                        LOG.error("N\u00e3o foi poss\u00edvel executar o restart", ex);
                    }
                }));
            }
            System.exit(0);
        }
        catch (Throwable ex) {
            LOG.error("N\u00e3o foi poss\u00edvel executar o restart", ex);
        }
    }

    public static void inicializarCertificadoA3RepositorioWindows(ConfigurableApplicationContext context) {
        EventQueue.invokeLater(() -> {
            CertificadoController certificadoController = (CertificadoController)context.getBean(CertificadoController.class);
            certificadoController.inicializarCertificadoA3RepositorioWindows();
        });
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/importacao/**"}).addResourceLocations(new String[]{"file:///" + System.getProperty("user.dir") + "/importacao/"});
        registry.addResourceHandler(new String[]{"/pafecf/tmp/**"}).addResourceLocations(new String[]{"file:///" + System.getProperty("user.dir") + "/pafecf/tmp/"});
        String diretorioBuilds = System.getProperty("user.dir") + "/builds_baixadas/";
        registry.addResourceHandler(new String[]{"/builds/**"}).addResourceLocations(new String[]{"file:///" + diretorioBuilds});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        boolean logarRequisicoes = PropriedadeRN.getInstance().getPropriedadeBoolean(this.yodaProperties.getFilial(), 738);
        if (logarRequisicoes) {
            registry.addInterceptor((HandlerInterceptor)new /* Unavailable Anonymous Inner Class!! */).addPathPatterns(new String[]{"/**"});
        }
    }

    static /* synthetic */ IConnectionHandler access$000(YodaApplication x0) {
        return x0.connectionHandler;
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }
}

