/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.commons.core.client.batch.BatchDashBoardResponse;
import br.intelidata.commons.core.client.batch.TaskRequest;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.yoda.app.batch.BatchDashBoard;
import br.intelidata.yoda.app.batch.TaskProcessorYoda;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/batch"})
public class BatchYodaController {
    private TaskProcessorYoda taskProcessorYoda;

    public BatchYodaController(TaskProcessorYoda taskProcessorYoda) {
        this.taskProcessorYoda = taskProcessorYoda;
    }

    @RequestMapping(value={"/dashboard"})
    @DBAutoCommit
    public BatchDashBoardResponse gerarDashBoard() {
        return new BatchDashBoard(this.taskProcessorYoda).gerar();
    }

    @RequestMapping(value={"/iniciartarefa"})
    @DBAutoCommit
    public void iniciarTarefa(@RequestBody TaskRequest request) throws UnicoMensagemUsuarioException {
        this.taskProcessorYoda.iniciar(request);
    }

    @RequestMapping(value={"/pausartarefa"})
    @DBAutoCommit
    public void pausarTarefa(@RequestBody TaskRequest request) throws UnicoMensagemUsuarioException {
        this.taskProcessorYoda.pausar(request);
    }

    @RequestMapping(value={"/pausarscheduler"})
    @DBAutoCommit
    public void pausarScheduler(@RequestBody TaskRequest request) throws UnicoMensagemUsuarioException {
        this.taskProcessorYoda.pausarScheduler(request);
    }

    @RequestMapping(value={"/alterarcron"})
    @DBAutoCommit
    public void alterarCron(@RequestBody TaskRequest request) throws UnicoMensagemUsuarioException {
        this.taskProcessorYoda.alterarCron(request);
    }
}

