/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.api.batch.ITask;
import br.intelidata.commons.core.client.batch.TaskRequest;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.batch.TaskQueue;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.yoda.app.batch.TaskQueueYodaDAO;
import br.intelidata.yoda.app.batch.TaskYodaDAO;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class TaskServiceYoda
implements ITask {
    private TaskYodaDAO taskDao;
    private TaskQueueYodaDAO taskQueueDao;

    public TaskServiceYoda(TaskYodaDAO taskDao, TaskQueueYodaDAO taskQueueDAO) {
        this.taskDao = taskDao;
        this.taskQueueDao = taskQueueDAO;
    }

    public synchronized Task saveTask(Task task) {
        return (Task)this.taskDao.save((AbstractPojo)task);
    }

    public synchronized void update(Task task) {
        this.taskDao.update((AbstractPojo)task);
    }

    public synchronized void deleteOldTasks(int days) {
        this.taskDao.deleteOldTasks();
    }

    public synchronized void inactiveAllRecurringJobsBlocked() {
        this.taskDao.changeTaskStatuses(TaskStatus.SCHEDULED, TaskStatus.INACTIVE);
        this.taskDao.changeTaskStatuses(TaskStatus.PAUSED, TaskStatus.INACTIVE);
        this.taskDao.changeTaskStatuses(TaskStatus.PROCESSING, TaskStatus.DELETED);
    }

    public synchronized void pausar(TaskRequest request) throws UnicoMensagemUsuarioException {
        Task task = this.findById(request.getId());
        if (task != null) {
            if (task.getTaskStatus() == TaskStatus.PAUSED) {
                return;
            }
            this.lancaExcecaoSeTarefaNaoEstaAgendada(task);
            task.setTaskStatus(TaskStatus.PAUSED);
            this.update(task);
        }
    }

    public synchronized void pausarScheduler(TaskRequest request) throws UnicoMensagemUsuarioException {
        Task task = this.findById(request.getId());
        if (task != null) {
            if (task.getTaskStatus() == TaskStatus.PAUSE_SCHEDULE) {
                return;
            }
            this.lancaExcecaoSeTarefaNaoEstaAgendada(task);
            task.setTaskStatus(TaskStatus.PAUSE_SCHEDULE);
            this.update(task);
        }
    }

    public synchronized void iniciar(TaskRequest request) throws UnicoMensagemUsuarioException {
        Task task = this.findById(request.getId());
        if (task != null) {
            if (task.getTaskStatus() == TaskStatus.SCHEDULED) {
                return;
            }
            if (task.getTaskStatus() != TaskStatus.PAUSED && task.getTaskStatus() != TaskStatus.PAUSE_SCHEDULE) {
                throw new UnicoMensagemUsuarioException("YODA39", "A tarefa n\u00e3o est\u00e1 mais pausada");
            }
            task.setTaskStatus(TaskStatus.SCHEDULED);
            this.update(task);
        }
    }

    public synchronized void alterarCron(TaskRequest request) throws UnicoMensagemUsuarioException {
        Task task = this.findById(request.getId());
        if (task != null) {
            this.lancaExcecaoSeTarefaNaoEstaAgendada(task);
            task.setCronExpression(request.getCronExpression());
            this.update(task);
        }
    }

    public List<Task> getRecurringTasksBlocked(String className) {
        return this.taskDao.findRecurringTasks(className);
    }

    public Task getTask(UUID uuid) {
        return this.taskDao.findByUuid(uuid.toString());
    }

    public Task findById(Long id) {
        return this.taskDao.findById(id);
    }

    public List<Task> getTasksToProcessBlocked(TaskStatus taskStatus, int limit, String ami) {
        return this.taskDao.findTasksToProcess(taskStatus, limit);
    }

    public List<Task> getTasks(String ami, TaskStatus ... taskStatus) {
        return this.taskDao.findByTaskStatus(taskStatus);
    }

    public List<String> getTenants() {
        return Collections.emptyList();
    }

    public Task findByTenantAndIdFilial(String tenant, String idFilial) {
        return this.taskDao.findByTenantAndIdFilial(tenant, idFilial);
    }

    public boolean verificaSeExistePorTipoTenant(TipoJob tipo, String tenant, boolean considerarFila) {
        return false;
    }

    public Task buscarUltimoTaskCargaBase(String metaData) {
        return this.taskDao.buscarUltimoTaskCargaBase(metaData);
    }

    public void initTaskQueue() {
        Set tiposFila = this.getFilas();
        HashSet gravadas = new HashSet(this.taskQueueDao.buscarLista());
        for (TaskQueue taskQueue : gravadas) {
            if (tiposFila.contains(taskQueue)) continue;
            this.taskQueueDao.delete((AbstractPojo)taskQueue);
        }
        for (TaskQueue taskQueue : tiposFila) {
            if (gravadas.contains(taskQueue)) continue;
            this.taskQueueDao.save((AbstractPojo)taskQueue);
        }
    }

    private Set<TaskQueue> getFilas() {
        HashSet<TaskQueue> filas = new HashSet<TaskQueue>();
        for (TypeQueue typeQueue : TypeQueue.values()) {
            TaskQueue taskQueue = new TaskQueue();
            taskQueue.setCode(typeQueue.getId());
            taskQueue.setName(typeQueue.getDescricao());
            taskQueue.setPriority(typeQueue.getPriority().intValue());
            taskQueue.setPaused(false);
            filas.add(taskQueue);
        }
        return filas;
    }

    private void lancaExcecaoSeTarefaNaoEstaAgendada(Task task) throws UnicoMensagemUsuarioException {
        if (task.getTaskStatus() != TaskStatus.SCHEDULED) {
            throw new UnicoMensagemUsuarioException("YODA38", "A tarefa n\u00e3o est\u00e1 mais agendada");
        }
    }

    public List<Task> findByQueue() {
        return this.taskDao.findByQueue();
    }
}

