/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.commons.core.sql.SqlNativo;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.yoda.app.batch.AbstractYodaDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Repository;

@Repository
public class TaskYodaDAO
extends AbstractYodaDAO<Task> {
    public List<Task> findByTaskStatus(TaskStatus ... taskStatus) {
        Integer[] status = (Integer[])Arrays.stream(taskStatus).map(TaskStatus::getId).toArray(Integer[]::new);
        return this.buscarLista(new Ordem("t0", true), new Condicao[]{new Condicao("taskstatus", Operador.CONTIDO_EM, status)});
    }

    public Task findByUuid(String uuid) {
        return (Task)this.buscarPor(new Condicao[]{new Condicao("uuid", Operador.IGUAL, uuid)});
    }

    public Task findById(Long idTask) {
        return (Task)this.buscarPor(new Condicao[]{new Condicao("id", Operador.IGUAL, idTask)});
    }

    public List<Task> findTasksToProcess(TaskStatus taskStatus, int limit) {
        ArrayList<Long> ids = new ArrayList<Long>();
        String strSql = this.select() + " left join taskqueue q on (q.code=t.queue) where t.taskstatus = ? and q.paused=0 order by q.priority,t.t0 limit ?";
        SqlNativo sql = new SqlNativo(strSql);
        sql.setInt(1, taskStatus.getId().intValue());
        sql.setInt(2, limit);
        sql.executaQuery();
        while (sql.next()) {
            ids.add(sql.getLong("id"));
        }
        sql.close();
        if (!Util.listNullOrEmpty(ids)) {
            return this.buscarLista(new Condicao[]{new Condicao("id", Operador.CONTIDO_EM, ids.toArray(new Long[0]))});
        }
        return Collections.emptyList();
    }

    public List<Task> findRecurringTasks(String className) {
        return this.buscarLista(new Condicao[]{new Condicao("taskstatus", Operador.CONTIDO_EM, new Integer[]{TaskStatus.INACTIVE.getId(), TaskStatus.PAUSE_SCHEDULE.getId()}), new Condicao("classname", Operador.IGUAL, className)});
    }

    public Task findByTenantAndIdFilial(String tenant, String idFilial) {
        return (Task)this.buscarPor(new Condicao[]{new Condicao("tenant", Operador.IGUAL, tenant), new Condicao("metadata", Operador.CONTEM, "idFilial=" + idFilial)});
    }

    public List<Task> findByQueue() {
        return this.buscarLista(new Condicao[]{new Condicao("queue", Operador.IGUAL, TypeQueue.EMAIL_QUEUE.getId()), new Condicao("taskstatus", Operador.IGUAL, TaskStatus.PROCESSING.getId().intValue())});
    }

    public boolean existeProcessoPendente(TipoJob ... tipoJob) {
        Integer[] ids = (Integer[])Stream.of(tipoJob).map(TipoJob::getId).toArray(Integer[]::new);
        return this.buscarPor(new Condicao[]{new Condicao("tipojob", Operador.CONTIDO_EM, ids), new Condicao("taskstatus", Operador.CONTIDO_EM, new Integer[]{TaskStatus.ENQUEUED.getId(), TaskStatus.PROCESSING.getId()})}) != null;
    }

    public void deleteOldTasks() {
        SqlNativo sql = new SqlNativo("delete from task where taskstatus <> 5 and extract(days from localtimestamp-t0) >= 7");
        sql.executaUpdate();
        sql.close();
    }

    public void changeTaskStatuses(TaskStatus from, TaskStatus to) {
        SqlNativo sql = new SqlNativo("update task set taskstatus = ? where taskstatus = ?");
        sql.setInt(1, to.getId().intValue());
        sql.setInt(2, from.getId().intValue());
        sql.executaUpdate();
        sql.close();
    }

    public Task buscarUltimoTaskCargaBase(String metaData) {
        ArrayList<Condicao> condicoes = new ArrayList<Condicao>();
        condicoes.add(new Condicao("tipojob", Operador.IGUAL, TipoJob.CARGA_BASE_YODA.getId().intValue()));
        condicoes.add(new Condicao("metadata", Operador.IGUAL, metaData));
        return (Task)this.buscarPor(1, new Ordem("id", true), condicoes.toArray(new Condicao[0]));
    }

    private String select() {
        String campos = Arrays.stream(Task.class.getDeclaredFields()).filter(field -> !field.getName().equalsIgnoreCase("id") && !field.getName().equalsIgnoreCase("name") && !field.getName().equalsIgnoreCase("proxima") && !field.getName().equalsIgnoreCase("excecao")).map(field -> field.getName().toLowerCase()).collect(Collectors.joining(", "));
        return "select t.id, t.name, " + campos + " from task t";
    }
}

