/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.exportacaoxml.pojo.ExportacaoXMLFiltro;
import br.intelidata.commons.modulo.exportacaoxml.regranegocio.ExportacaoXMLDesktop;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.time.LocalDate;
import java.util.Collections;

public class ExportacaoXMLScheduler
extends RecurringYodaJob {
    private ExportacaoXMLFiltro filtros;

    public ExportacaoXMLScheduler() {
        super(Cron.daily((int)3), TipoJob.EXPORTACAO_XML_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
        this.filtros = this.buscarFiltro();
    }

    public void execute() throws UnicoMensagemUsuarioException {
        LocalDate inicio = DataHoraFactory.getData().minusMonths(1L).withDayOfMonth(1);
        LocalDate fim = DataHoraFactory.getData().withDayOfMonth(1).minusDays(1L);
        this.filtros.setDataInicial(inicio);
        this.filtros.setDataFinal(fim);
        for (Filial filial : FilialRN.getInstance().buscarLista()) {
            Sessao sessao = Sessao.createSessao((Long)filial.getId());
            this.filtros.setIdFiliais(Collections.singletonList(filial.getId()));
            this.filtros.setCodigoFiliais(Collections.singletonList(filial.getCodigo()));
            if (this.filtros.isGravarEmDiretorio()) {
                new ExportacaoXMLDesktop().gravarArquivos(sessao, this.filtros, false);
                continue;
            }
            this.enviarPorEmail(filial, sessao);
        }
    }

    private void enviarPorEmail(Filial filial, Sessao sessao) throws UnicoMensagemUsuarioException {
        String email = this.filtros.getEmail();
        if (this.filtros.isEnviarEmailContador()) {
            email = filial.getContador().getEmail();
        }
        if (Util.stringNullOrEmpty((String)email)) {
            throw new UnicoMensagemUsuarioException("YODA30", "Os XMLs da filial c\u00f3digo [" + filial.getCodigo() + "} n\u00e3o foram exportados. Configure o e-mail " + (this.filtros.isEnviarEmailContador() ? "no cadastro do contador." : "no agendamento."));
        }
        this.filtros.setEmail(email);
        new ExportacaoXMLDesktop().enviaEmail(sessao, this.filtros);
    }

    public boolean isAtivo() {
        return this.filtros != null && !this.getCronExpression().isEmpty();
    }

    public String getCronExpression() {
        if (this.filtros == null || Util.stringNullOrEmpty((String)this.filtros.getHoraAgendamento())) {
            return "";
        }
        String[] arrayHora = this.filtros.getHoraAgendamento().split(":");
        return Cron.monthly((int)this.filtros.getDiaAgendamento(), (int)Util.string2int((String)arrayHora[0]), (int)Util.string2int((String)arrayHora[1]));
    }

    private ExportacaoXMLFiltro buscarFiltro() {
        String jsonAgendamento = PropriedadeRN.getInstance().getPropriedadeString(Contexto.getInstance().getFilial(), 719);
        if (Util.stringNullOrEmpty((String)jsonAgendamento)) {
            return null;
        }
        return (ExportacaoXMLFiltro)JSONUtil.getObject((String)jsonAgendamento, ExportacaoXMLFiltro.class);
    }
}

