/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.sistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.ConnectionSql;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.util.agendador.BackupResultado;
import br.intelidata.commons.core.util.agendador.ExecutarBackup;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Agendamento;
import br.intelidata.commons.domain.pojo.BackupAgendado;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.BackupAgendadoCommonRN;
import br.intelidata.commons.modulo.ferramentas.agendamento.regranegocio.BackupAgendadoRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;

public class BackupYodaScheduler
extends RecurringYodaJob {
    private BackupAgendado agendamento = BackupAgendadoCommonRN.getInstance().buscaBackupAgendado();

    public BackupYodaScheduler() {
        super(Cron.daily((int)3), TipoJob.BACKUP_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        String diretorioPostgres = Util.getDiretorioPostgres();
        String nomeBaseDados = ConnectionSql.getConfiguraConexao().getBaseDados();
        BackupResultado resultado = new ExecutarBackup().executa(nomeBaseDados, diretorioPostgres, true);
        this.getTask().setRetorno(this.getRetorno(resultado));
        if (!resultado.isBackupGerado()) {
            throw new UnicoMensagemUsuarioException("YODA32", "Falha ao gerar backup");
        }
    }

    public boolean isAtivo() {
        return this.agendamento != null && !Util.stringNullOrEmpty((String)this.agendamento.getHoras());
    }

    public String getCronExpression() {
        return BackupAgendadoRN.getInstance().getExpressaoCron((Agendamento)this.agendamento, "0");
    }

    private String getRetorno(BackupResultado resultado) {
        StringBuilder sb = new StringBuilder();
        sb.append(resultado.getMensagemRetorno()).append("\n");
        sb.append("Tamanho Diferente: ").append(resultado.isTamanhoDiferente()).append("\n");
        return sb.toString();
    }
}

