/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.unimobile;

import br.intelidata.commons.core.IconesFactory;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.SessaoUnimobile;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoSessaoUnimobile;
import br.intelidata.commons.domain.regranegocio.SessaoUnimobileRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.atualizador.componentes.YodaDateCellRenderer;
import br.intelidata.yoda.app.atualizador.componentes.YodaEnumCellRenderer;
import br.intelidata.yoda.app.atualizador.componentes.YodaTable;
import br.intelidata.yoda.app.atualizador.componentes.YodaTableModelColuna;
import br.intelidata.yoda.app.unimobile.JanelaSessaoUnimobile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanelaSessaoUnimobile
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(JanelaSessaoUnimobile.class);
    private JButton btnSair;
    private JButton btnComanda;
    private JButton btnExcluir;
    private JButton btnRefresh;
    private YodaTable<SessaoUnimobile> tabelaSessoes;
    private final IConnectionHandler connectionHandler;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public JanelaSessaoUnimobile(IConnectionHandler connectionHandler) {
        super("Sess\u00f5es Unimobile - " + UnicoSistema.getVersao());
        this.connectionHandler = connectionHandler;
        this.setIconImage(IconesFactory.getImageIcon((String)IconesFactory.Aplicacao.ICONE_APLICACAO).getImage());
        this.setDefaultCloseOperation(2);
        this.initComponentes();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(d.width - 200, d.height - 200);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.carregarInformacoes();
    }

    private void initComponentes() {
        JPanel panelGeral = new JPanel(new BorderLayout(5, 5));
        panelGeral.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelSessoes = new JPanel(new BorderLayout());
        panelSessoes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        panelSessoes.add(new JScrollPane((Component)this.getTabelaSessoes()));
        panelGeral.add((Component)panelSessoes, "Center");
        panelGeral.add((Component)this.getPanelBotoes(), "South");
        this.getContentPane().add(panelGeral);
    }

    private JPanel getPanelBotoes() {
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.setBorder(BorderFactory.createTitledBorder(""));
        panelBotoes.add(this.getBtnRefresh());
        panelBotoes.add(this.getBtnExcluir());
        if (LicencaManager.getInstance().isUniMobileComanda()) {
            panelBotoes.add(this.getBtnComanda());
        }
        panelBotoes.add(this.getBtnSair());
        return panelBotoes;
    }

    private YodaTable<SessaoUnimobile> getTabelaSessoes() {
        if (this.tabelaSessoes == null) {
            ArrayList<YodaTableModelColuna> colunas = new ArrayList<YodaTableModelColuna>();
            colunas.add(new YodaTableModelColuna("nomeVendedor", "Nome do vendedor", 100));
            colunas.add(new YodaTableModelColuna("dtAbertura", "Cria\u00e7\u00e3o da sess\u00e3o", 50, (TableCellRenderer)new YodaDateCellRenderer()));
            colunas.add(new YodaTableModelColuna("dtAcesso", "\u00daltimo acesso", 50, (TableCellRenderer)new YodaDateCellRenderer()));
            colunas.add(new YodaTableModelColuna("ativa", "Sess\u00e3o ativa/aberta", 50, (TableCellRenderer)new YodaEnumCellRenderer(EnumSimNao.class)));
            colunas.add(new YodaTableModelColuna("tipoSessao", "Tipo da sess\u00e3o", 50));
            this.tabelaSessoes = new YodaTable(colunas);
            this.tabelaSessoes.setAutoCreateRowSorter(true);
            this.tabelaSessoes.setSelectionMode(0);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.tabelaSessoes.setPreferredScrollableViewportSize(new Dimension(d.width - 250, d.height - 250));
        }
        return this.tabelaSessoes;
    }

    private void carregarSessoes() {
        this.executarAcaoDB(() -> {
            this.getTabelaSessoes().getModelo().clear();
            this.getTabelaSessoes().getFonteDados().addAll(SessaoUnimobileRN.getInstance().buscarListaYoda());
            this.getTabelaSessoes().fireTableDataChanged();
        });
    }

    private void carregarInformacoes() {
        new Thread(() -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.carregarSessoes();
            this.setCursor(Cursor.getDefaultCursor());
        }).start();
    }

    public JButton getBtnComanda() {
        if (this.btnComanda == null) {
            this.btnComanda = new JButton("Excluir sess\u00f5es comanda (CTRL + F4)");
            this.btnComanda.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.EXCLUIR));
            this.btnComanda.addActionListener(e -> this.excluirComanda());
            this.btnComanda.registerKeyboardAction(al -> this.excluirComanda(), KeyStroke.getKeyStroke(115, 128), 2);
        }
        return this.btnComanda;
    }

    private void excluirComanda() {
        if (Util.listNullOrEmpty((List)this.getTabelaSessoes().getFonteDados())) {
            return;
        }
        int resposta = JOptionPane.showConfirmDialog(null, "Deseja remover as sess\u00f5es ativas? Os dados n\u00e3o sincronizados deste aparelho podem ser perdidos.", "Comanda", 0);
        if (resposta == 0) {
            this.executarAcaoDB(() -> {
                SessaoUnimobileRN.getInstance().excluirTodosPorTipo(Contexto.getInstance().getSessao(), TipoSessaoUnimobile.COMANDA);
                this.carregarInformacoes();
                this.getTabelaSessoes().fireTableDataChanged();
            });
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getDefaultCursor());
    }

    public JButton getBtnExcluir() {
        if (this.btnExcluir == null) {
            this.btnExcluir = new JButton("Excluir (F4)");
            this.btnExcluir.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.EXCLUIR));
            this.btnExcluir.addActionListener(arg_0 -> this.excluirSessoes(arg_0));
            this.btnExcluir.registerKeyboardAction(arg_0 -> this.excluirSessoes(arg_0), KeyStroke.getKeyStroke(115, 0), 2);
        }
        return this.btnExcluir;
    }

    public JButton getBtnSair() {
        if (this.btnSair == null) {
            this.btnSair = new JButton("Fechar (ESC)");
            this.btnSair.setToolTipText("Fecha a janela");
            this.btnSair.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.FECHAR));
            this.btnSair.addActionListener(e -> this.dispose());
            this.btnSair.registerKeyboardAction(al -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        }
        return this.btnSair;
    }

    public JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton("Atualizar (F5)");
            this.btnRefresh.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.REFRESH));
            this.btnRefresh.registerKeyboardAction(al -> this.carregarInformacoes(), KeyStroke.getKeyStroke(116, 0), 2);
            this.btnRefresh.addActionListener(e -> this.carregarInformacoes());
        }
        return this.btnRefresh;
    }

    private SessaoUnimobile buscaSessaoSelecionada() {
        AtomicReference sessaoUnimobile = new AtomicReference();
        if (this.getTabelaSessoes().getObjetoSelecionado() != null) {
            this.executarAcaoDB(() -> sessaoUnimobile.set(SessaoUnimobileRN.getInstance().buscarPorId(((SessaoUnimobile)this.getTabelaSessoes().getObjetoSelecionado()).getId())));
        }
        return (SessaoUnimobile)sessaoUnimobile.get();
    }

    private boolean podeExcluir() {
        boolean antiga;
        if (Util.listNullOrEmpty((List)this.getTabelaSessoes().getFonteDados()) || this.getTabelaSessoes().getObjetoSelecionado() == null) {
            return false;
        }
        SessaoUnimobile sessaoUnimobile = this.buscaSessaoSelecionada();
        if (sessaoUnimobile == null) {
            JOptionPane.showMessageDialog((Component)this, "Sess\u00e3o n\u00e3o encontrada", "Mobile", 1);
            this.carregarInformacoes();
            return false;
        }
        if (sessaoUnimobile.getTipoSessao().in(new AbstractEnum[]{TipoSessaoUnimobile.COMANDA, TipoSessaoUnimobile.POS_INTEGRADO})) {
            return true;
        }
        boolean aberturaAntiga = ChronoUnit.DAYS.between(sessaoUnimobile.getDtAbertura(), LocalDateTime.now(Contexto.getInstance().getZoneId())) >= 1L;
        boolean bl = antiga = ChronoUnit.DAYS.between(sessaoUnimobile.getDtAcesso(), LocalDateTime.now(Contexto.getInstance().getZoneId())) >= 1L;
        if (aberturaAntiga && antiga) {
            if (sessaoUnimobile.isAtiva()) {
                int resposta = JOptionPane.showConfirmDialog(null, "Deseja remover uma sess\u00e3o ativa? Os dados n\u00e3o sincronizados deste aparelho podem ser perdidos.", "Mobile", 0);
                return resposta == 0;
            }
        } else {
            JOptionPane.showMessageDialog((Component)this, "Apenas sess\u00f5es com mais de 24h de inatividade podem ser removidas", "Mobile", 2);
            return false;
        }
        return true;
    }

    private void excluirSessoes(ActionEvent e) {
        if (this.podeExcluir()) {
            SessaoUnimobile sessaoUnimobile = this.buscaSessaoSelecionada();
            this.executarAcaoDB(() -> SessaoUnimobileRN.getInstance().excluir((AbstractPojo)sessaoUnimobile, Contexto.getInstance().getSessao()));
            this.carregarInformacoes();
        }
    }

    private void executarAcaoDB(ExecutarAcaoDB executarAcaoDB) {
        this.connectionHandler.createConnection(false);
        try {
            executarAcaoDB.executar();
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
        finally {
            this.connectionHandler.releaseConnection();
        }
    }
}

