/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.core.spring.aop;

import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.StatelessRequest;
import br.intelidata.core.aop.DBAutoCommitExecutor;
import br.intelidata.core.sgdb.IConnectionHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBAutoCommitYoda
implements DBAutoCommitExecutor {
    private static final ThreadLocal<Sessao> holder = new ThreadLocal();
    private final IConnectionHandler connectionHandler;

    @Autowired
    public DBAutoCommitYoda(IConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public Object dbCommit(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object value;
        if (proceedingJoinPoint.getArgs().length > 0 && proceedingJoinPoint.getArgs()[0] instanceof StatelessRequest) {
            StatelessRequest req = (StatelessRequest)proceedingJoinPoint.getArgs()[0];
            Sessao sessao = req.getSessao();
            holder.set(sessao);
        }
        this.connectionHandler.createConnection(true);
        try {
            value = proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.connectionHandler.releaseConnection();
            holder.remove();
        }
        return value;
    }
}

